##### API PM best practices 
https://reddit.com/r/ProductManagement/s/Y1PHgdGubR
You should have a foundational understanding of how APIs work, but the best practices and design should be implemented by the devs. If you are PM of the API product, your primary concern should be usability and value delivery. I've managed a few API products over the years and here's a few things that have always worked for me:

1. ﻿﻿﻿Break down your consumers' needs into user stories the same as you would any other product. This requires user interviews just as any other product would as well. For example, do your users need to do repetitive, scheduled "set it and forget it" jobs, or do they need more dynamic queries on-demand? How should the returned data be structured in order to accomplish those jobs? This affects how you would approach the API architecturally (again, the devs will know much better than you, but it's your job to get this info for them).
2. ﻿﻿﻿If the API already exists and isn't being built from the ground up, use something like Postman to get your hands dirty and start using the API to accomplish simple tasks yourself. This will teach you faster than probably any other method. Troubleshooting things like authentication and query parameters will build your knowledge and also help your ability to field external support questions and reduce the burden on the dev team when possible. You shouldn't be afraid to ask your team questions if you get stuck.
3. GOOD documentation is crucial to the adoption and success of the product. Read examples of top-notch documentation like this one. It should be clear and concise while giving examples of both requests and responses. There are a lot of tools out there that make this easy for devs to publish, it just requires some extra "human touch" to make it more intuitive beyond the auto generated docs.
4. ﻿﻿﻿Error messages should always be actionable. Vague error messages are just as bad as empty ones in many cases.
5. Set your metrics. Depending on the product, goals, and maturity level, it could be based on unique transactions, performance, retention, errors, etc. Ask developers to send these events to whichever product analytics tool you are using so that you don't have to miserably sift through something like kibana or datadog because you'll have a much harder time trying to build relevant metrics reports beyond basic stats.

These are just some examples of a REST consumer API product, but they could be applied to most other implementations.
